% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covercorr_internal.R
\name{plot_rectangles}
\alias{plot_rectangles}
\title{Plot a collection of axis-aligned rectangles in the unit square}
\usage{
plot_rectangles(xmin, xmax, ymin, ymax, add = FALSE)
}
\arguments{
\item{xmin}{Numeric vector of left x-coordinates.}

\item{xmax}{Numeric vector of right x-coordinates (same length as \code{xmin}).}

\item{ymin}{Numeric vector of bottom y-coordinates (same length as \code{xmin}).}

\item{ymax}{Numeric vector of top y-coordinates (same length as \code{xmin}).}

\item{add}{Logical; if \code{TRUE}, add to an existing plot. Default \code{FALSE}.}
}
\value{
Invisibly returns \code{NULL}. Use this function for its plotting output, not for a returned value.
}
\description{
Draws rectangles specified by their \code{xmin}, \code{xmax}, \code{ymin},
and \code{ymax}, optionally adding them to an existing plot. When
\code{add = FALSE}, a fresh \eqn{[0,1]\times[0,1]} plot with a grid and
equal aspect ratio is created.
}
