% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srcref_df.R
\name{pkg_srcrefs_df}
\alias{pkg_srcrefs_df}
\title{Create a data.frame of package srcref objects}
\usage{
pkg_srcrefs_df(x)
}
\arguments{
\item{x}{A \code{\link[covr]{package_coverage}} coverage object, from which
the name of the package used is extracted.}
}
\value{
A \code{data.frame} with a record for each source code block with
variables:

\describe{
\item{name}{A \code{character} Rd alias for the package object}
\item{srcref}{The \code{srcref} of the associated package source code}
}
}
\description{
Create a data.frame of package srcref objects
}
\examples{
pkg <- system.file("examplepkg", package = "covtracer")
install.packages(
  pkg,
  type = "source",
  repos = NULL,
  quiet = TRUE,
  INSTALL_opts = "--with-keep.source"
)
pkg_srcrefs_df("examplepkg")

}
\seealso{
srcrefs test_trace_mapping

Other srcrefs_df: 
\code{\link{test_srcrefs_df}()},
\code{\link{trace_srcrefs_df}()}
}
\concept{srcrefs_df}
