% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CowbellAnalyzer.R
\name{generateCowbellConcept}
\alias{generateCowbellConcept}
\title{Expresses the fitting formula and the value range of the variables.}
\usage{
generateCowbellConcept(formula, minDest = NA, maxDest = NA, minSrcA = NA,
  maxSrcA = NA, minSrcB = NA, maxSrcB = NA)
}
\arguments{
\item{formula}{The formula essentially specifying the names of the dependend variable (here Dest)
and the two independent variables (here SrcA, SrcB). Example: Dest ~ SrcA * SrcB.}

\item{minDest}{The a prior known minimal value the dependend variable (Dest) can have.}

\item{maxDest}{The a prior known maximal value the dependend variable (Dest) can have.}

\item{minSrcA}{The a prior known minimal value the first dependend variable (SrcA) can have.}

\item{maxSrcA}{The a prior known maximal value the first dependend variable (SrcA) can have.}

\item{minSrcB}{The a prior known minimal value the second dependend variable (SrcB) can have.}

\item{maxSrcB}{The a prior known maximal value the second dependend variable (SrcB) can have.}
}
\value{
List of the aggregate information. This is used in the regression analysis.
}
\description{
Generates a concept which is basically the formula used for the regression analysis and minimal and maximal
values of the dependent and two independent variables. As this package creates a very specific regression model
the formula is always of the form Dest ~ SrcA * SrcB. If one of the minimal and maximal values are omitted,
the minimum or maximum value of the data set will be used later on.
}
\examples{
concept<-generateCowbellConcept(Fun ~ Fluency * Absorption, 1, 9, 1, 7, 1, 7)
}
