% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpop.crops.R
\name{cpop.crops}
\alias{cpop.crops}
\alias{crops.cpop,cpop.crops.class-method}
\title{Calculate changepoint locations over a range of penalty values}
\usage{
cpop.crops(
  y,
  x = 1:length(y),
  grid = x,
  beta_min = 1.5 * log(length(y)),
  beta_max = 2.5 * log(length(y)),
  sd = sqrt(mean(diff(diff(y))^2)/6),
  minseglen = 0,
  prune.approx = FALSE
)
}
\arguments{
\item{y}{A vector of length n containing the data.}

\item{x}{A vector of length n containing the locations of y. Default value is NULL, in which case the locations \code{x = 1:length(y)-1} are assumed.}

\item{grid}{An ordered vector of possible locations for the change points. If this is NULL, then this is set to x, the vector of times/locations of the data points.}

\item{beta_min}{Minimum value of the penalty range to be searched. Default is \code{1.5*log(length(y))}}

\item{beta_max}{Maximum value of the penalty range to be searched. Default is \code{2.5*log(length(y))}}

\item{sd}{Estimate of residual standard deviation. Can be a single numerical value or a vector of values for the case of varying standard deviation.
Default value is \code{sd = sqrt(mean(diff(diff(y))^2)/6)}.}

\item{minseglen}{The minimum allowable segment length, i.e. distance between successive changepoints. Default is 0.}

\item{prune.approx}{Only relevant if a minimum segment length is set. If TRUE, cpop will use an approximate pruning algorithm that will speed up computation but may
occasionally lead to a sub-optimal solution in terms of the estimate change point locations. If the minimum segment length is 0, then an exact pruning algorithm is possible and is used.}
}
\value{
An instance of an S4 class of type cpop.crops.class which extends the crops.class in \pkg{crops}.
}
\description{
Runs the Changepoints for a Range of Penalties (CROPS) algorithm of Haynes et al. (2017) to find all of the optimal segmentations for multiple penalty values over a continuous range.
For details of the CROPS method see the \pkg{\link[crops]{crops}} package. To obtain details for each segmentation determined by \code{\link[cpop]{cpop.crops}} use the 
\code{\link[crops]{segmentations}} method (see example below).
}
\examples{
\donttest{
library(cpop)

# generate some data
set.seed(0)
x <- seq(0,1,0.01)
n <- length(x)
sd <- rep(0.1,n)
mu <- c(2*x[1:floor(n/2)],2 - 2*x[(floor(n/2)+1):n])
y <- rnorm(n,mu,sd)
# calculate the changepoint locations and cost over a range of penalty values
res <- cpop.crops(y,x,sd=sd,beta_min=0.4*log(length(y)),beta_max=2.5*log(length(y)))
summary(res)

# plot the results
plot(res) 

# show the segmentations
 segmentations(res)
}

}
\references{
\insertRef{crops-article}{cpop}

\insertRef{crops-package}{cpop}

\insertRef{cpop-jss-article-2024}{cpop}
}
