% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cpr_cp.R
\name{plot.cpr_cp}
\alias{plot.cpr_cp}
\title{Plotting Control Polygons}
\usage{
\method{plot}{cpr_cp}(
  x,
  ...,
  comparative,
  show_cp = TRUE,
  show_spline = FALSE,
  show_xi = TRUE,
  color = FALSE,
  n = 100,
  show_x = FALSE,
  digits = 2
)
}
\arguments{
\item{x}{a \code{cpr_cp} object}

\item{...}{additional \code{cpr_cp} objects}

\item{comparative}{when \code{TRUE} use \code{color} to distinguish one spline from
another, when \code{FALSE} \code{color} to highlight the control polygon and
spline with different colors, and plot the knots the way
\code{\link{plot.cpr_bs}} does.  When missing, the default if \code{TRUE} if
more than one \code{cpr_cp} object is passed in, and \code{FALSE} is only one
\code{cpr_cp} object is passed.}

\item{show_cp}{logical (default \code{TRUE}), show the control polygon(s)?}

\item{show_spline}{logical (default \code{FALSE}) to plot the spline
function?}

\item{show_xi}{logical (default \code{TRUE}) use
\code{\link[ggplot2]{geom_rug}} to show the location of the knots in the
respective control polygons.}

\item{color}{Boolean (default FALSE) if more than one \code{cpr_cp} object is
to be plotted, set this value to TRUE to have the graphic in color (line types
will be used regardless of the color setting).}

\item{n}{the number of data points to use for plotting the spline}

\item{show_x}{boolean, so x-values}

\item{digits}{number of digits to the right of the decimal place to report
for the value of each knot. Only used when plotting on control polygon with
\code{comparative = FALSE}.}
}
\value{
a ggplot object
}
\description{
Plotting control polygon(s) and/or the associated spline(s) via ggplot2
}
\examples{

x <- runif(n = 500, 0, 6)
bmat <- bsplines(x, iknots = c(1, 1.5, 2.3, 4, 4.5), bknots = c(0, 6))
theta1 <- matrix(c(1, 0, 3.5, 4.2, 3.7, -0.5, -0.7, 2, 1.5), ncol = 1)
theta2 <- theta1 + c(-0.15, -1.01, 0.37, 0.19, -0.53, -0.84, -0.19, 1.15, 0.17)
cp1 <- cp(bmat, theta1)
cp2 <- cp(bmat, theta2)

# compare two control polygons on one plot
plot(cp1, cp2)
plot(cp1, cp2, color = TRUE)
plot(cp1, cp2, color = TRUE, show_spline = TRUE)
plot(cp1, cp2, color = TRUE, show_cp = FALSE, show_spline = TRUE)

# Show one control polygon with knots on the axis instead of the rug and
# color/linetype for the control polygon and spline, instead of different
# control polygons
plot(cp1, comparative = FALSE)
plot(cp1, comparative = FALSE, show_spline = TRUE)
plot(cp1, comparative = FALSE, show_spline = TRUE, show_x = TRUE)
plot(cp2, comparative = FALSE, show_spline = TRUE, show_x = TRUE)


}
