% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cps_download.R
\name{cps_download_data}
\alias{cps_download_data}
\title{Download CPS microdata}
\usage{
cps_download_data(
  path = "cps_data",
  years = seq(1994, 2018, 2),
  overwrite = FALSE
)
}
\arguments{
\item{path}{A file path (relative or absolute) where the downloads should go.}

\item{years}{Which years of data to download. Defaults to all
even-numbered years from 1994 to 2018.}

\item{overwrite}{Logical, whether to write over existing files or not.
Defaults to FALSE.}
}
\description{
Download CPS microdata
}
\details{
\itemize{
\item File names will be written in the style "cps_nov2018.zip", with the
appropriate years.
\item The Voting and Registration Supplement is only conducted in even-numbered
years (since 1964), so any entry in \code{years} outside of this will be skipped.
\item Currently the package only supports downloads from 1994 onwards, so any
entry in \code{years} before 1994 will be skipped.
}
}
\examples{
\dontrun{
cps_download_data(path = "cps_docs", years = 2016, overwrite = TRUE)
}

}
