% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_activity.R
\name{sch_get_activity}
\alias{sch_get_activity}
\title{Get Activity}
\usage{
sch_get_activity(sch, aid)
}
\arguments{
\item{sch}{A schedule object.}

\item{aid}{An activity id as defined by the user.}
}
\value{
A an activity information in a tibble with one line,
or an error if activity id doesn't exist.
}
\description{
Gets an activity by id.
}
\examples{
sch <- sch_new() \%>\%
  sch_add_activities(
    id        = 1:17,
    name      = paste("a", as.character(1:17), sep=""),
    duration  = c(1L,2L,2L,4L,3L,3L,3L,2L,1L,1L,2L,1L,1L,1L,1L,2L,1L)
  ) \%>\%
  sch_plan()
sch_get_activity(sch, 7)

}
\seealso{
\code{\link[=sch_activities]{sch_activities()}}, \code{\link[=sch_duration]{sch_duration()}}, \code{\link[=sch_nr_activities]{sch_nr_activities()}},
\code{\link[=sch_add_activities]{sch_add_activities()}}, \code{\link[=sch_critical_activities]{sch_critical_activities()}}, \code{\link[=sch_has_any_activity]{sch_has_any_activity()}},
\code{\link[=sch_change_activities_duration]{sch_change_activities_duration()}}, \code{\link[=sch_add_activity]{sch_add_activity()}}.
}
