% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netgraph.crossnma.R
\name{netgraph.crossnma}
\alias{netgraph.crossnma}
\title{Produce a network plot}
\usage{
\method{netgraph}{crossnma}(
  x,
  labels,
  adj = NULL,
  offset = if (!is.null(adj) && all(unique(adj) == 0.5)) 0 else 0.0175,
  points = !missing(cex.points),
  cex.points = 1,
  ...
)
}
\arguments{
\item{x}{An object produced by \code{\link{crossnma}}.}

\item{labels}{An optional vector with treatment labels.}

\item{adj}{One, two, or three values in [0, 1] (or a vector /
matrix with length / number of rows equal to the number of
treatments) specifying the x (and optionally y and z) adjustment
for treatment labels.}

\item{offset}{Distance between edges (i.e. treatments) in graph and
treatment labels for 2-D plots (value of 0.0175 corresponds to a
difference of 1.75\% of the range on x- and y-axis).}

\item{points}{A logical indicating whether points should be printed
at nodes (i.e. treatments) of the network graph.}

\item{cex.points}{Corresponding size for points. Can be a vector
with length equal to the number of treatments.}

\item{...}{\dots Additional arguments (passed on to
\code{\link[netmeta]{netgraph.netmeta}}).}
}
\value{
A data frame containing the following columns:
\item{labels}{Treatment labels.}
\item{seq}{Sequence of treatment labels.}
\item{xpos}{Position of treatment / edge on x-axis.}
\item{ypos}{Position of treatment / edge on y-axis.}
\item{zpos}{Position of treatment / edge on z-axis (for 3-D
  plots).}
\item{xpos.labels}{Position of treatment labels on x-axis (for 2-D
  plots).}
\item{ypos.labels}{Position of treatment labels on y-axis (for 2-D
  plots).}
\item{adj.x}{Adjustment for treatment label on x-axis.}
\item{adj.y}{Adjustment for treatment label on y-axis.}
\item{adj.z}{Adjustment for treatment label on z-axis (for 3-D
  plots).}
}
\description{
Create a network plot of the cross network meta-analysis or
meta-regression
}
\examples{
\dontrun{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
stddata # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
set.seed(1909)
fit <- crossnma(mod)

# Create network plot
netgraph(fit, plastic = FALSE, cex.points = 7, adj = 0.5)
}

}
\seealso{
\code{\link[netmeta]{netgraph.netmeta}}
}
\author{
Tasnim Hamza \email{hamza.a.tasnim@gmail.com}
}
