% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_crs.R
\name{crs_input}
\alias{crs_input}
\title{Extract 'input' value}
\usage{
crs_input(x, ...)
}
\arguments{
\item{x}{object with 'input' value}

\item{...}{ignored}
}
\value{
character (or NA)
}
\description{
Obtain the 'input' string from an object, if it has one. Supported inputs
include sf (>= 0.8-1 - probably).
}
\section{Warning}{


Note that the 'input' value could be almost anything, there is a
huge variety of inputs that can work such as \code{4326}, projstrings,
WKT2 strings, EPSG declarations \code{'EPSG:4326'}, or common strings like
\code{'WGS84'} or \code{'NAD27'}.

Strings like \code{'+init=epsg:4326'} have been deprecated but still
can work, so beware.
}

\examples{
crs_input(sfx) ## doesn't have one

crs_input(sfx_new)  ## a proj4string
}
\references{
\href{http://r-spatial.github.io/sf/}{sf}
}
\seealso{
\code{\link[=crs_wkt2]{crs_wkt2()}} \code{\link[=crs_proj]{crs_proj()}} \code{\link[=crs_epsg]{crs_epsg()}}
}
