% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGeneralizedCore.R
\name{makeSubCoreList}
\alias{makeSubCoreList}
\title{Get list of core rules from random subsets of samples}
\usage{
makeSubCoreList(D, Q, rm, til, num.subsets, num.evaluated, shouldPrint)
}
\arguments{
\item{D}{input matrix D}

\item{Q}{input matrix Q}

\item{rm}{binary rule matrix}

\item{til}{list of top rule set index matrices}

\item{num.subsets}{number of subset iterations, default is 100}

\item{num.evaluated}{number of top rs considered per k per iteration, default is 1000}

\item{shouldPrint}{Print progress updates? Default is TRUE}
}
\description{
Get list of core rules from random subsets of samples
}
\examples{
library(crso)
data(skcm)
list2env(skcm.list,envir=globalenv())
Q <- log10(P)
rm.full <- buildRuleLibrary(D,rule.thresh = 0.05) # Rule library matrix, dimension: 60 x 71
til.p2 <- makePhaseTwoImList(D,Q,rm.full,k.max = 3,
          pool.sizes=c(60,20,20),max.stored=100,shouldPrint = FALSE)
subcore.list <- makeSubCoreList(D,Q,rm.full,til.p2,num.subsets=3,num.evaluated=50)
}
