% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/short_term_trend.R
\name{short_term_trend}
\alias{short_term_trend}
\alias{short_term_trend.csfmt_rts_data_v1}
\title{Determine the short term trend of a timeseries}
\usage{
short_term_trend(x, ...)

\method{short_term_trend}{csfmt_rts_data_v1}(
  x,
  numerator,
  denominator = NULL,
  prX = 100,
  trend_isoyearweeks = 6,
  remove_last_isoyearweeks = 0,
  forecast_isoyearweeks = trend_isoyearweeks,
  numerator_naming_prefix = "from_numerator",
  denominator_naming_prefix = "from_denominator",
  statistics_naming_prefix = "universal",
  remove_training_data = FALSE,
  include_decreasing = FALSE,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{x}{Data object}

\item{...}{Not in use.}

\item{numerator}{Character of name of numerator}

\item{denominator}{Character of name of denominator (optional)}

\item{prX}{If using denominator, what scaling factor should be used for numerator/denominator?}

\item{trend_isoyearweeks}{Same as trend_dates, but used if granularity_geo=='isoyearweek'}

\item{remove_last_isoyearweeks}{Same as remove_last_dates, but used if granularity_geo=='isoyearweek'}

\item{forecast_isoyearweeks}{Same as forecast_dates, but used if granularity_geo=='isoyearweek'}

\item{numerator_naming_prefix}{"from_numerator", "generic", or a custom prefix}

\item{denominator_naming_prefix}{"from_denominator", "generic", or a custom prefix}

\item{statistics_naming_prefix}{"universal" (one variable for trend status, one variable for doubling dates), "from_numerator_and_prX" (If denominator is NULL, then one variable corresponding to numerator. If denominator exists, then one variable for each of the prXs)}

\item{remove_training_data}{Boolean. If TRUE, removes the training data (i.e. 1:(trend_dates-1) or 1:(trend_isoyearweeks-1)) from the returned dataset.}

\item{include_decreasing}{If true, then *_trend*_status contains the levels c("training", "forecast", "decreasing", "null", "increasing"), otherwise the levels c("training", "forecast", "notincreasing", "increasing").}

\item{alpha}{Significance level for change in trend.}
}
\value{
The original csfmt_rts_data_v1 dataset with extra columns. *_trend*_status contains a factor with levels c("training", "forecast", "decreasing", "null", "increasing"), while *_doublingdays* contains the expected number of days before the numerator doubles.
}
\description{
The method is based upon a published analytics strategy by Benedetti (2019) <doi:10.5588/pha.19.0002>.
}
\examples{
d <- cstidy::nor_covid19_icu_and_hospitalization_csfmt_rts_v1
d <- d[granularity_time=="isoyearweek"]
res <- csalert::short_term_trend(
  d,
  numerator = "hospitalization_with_covid19_as_primary_cause_n",
  trend_isoyearweeks = 6
)
print(res[, .(
  isoyearweek,
  hospitalization_with_covid19_as_primary_cause_n,
  hospitalization_with_covid19_as_primary_cause_trend0_41_status
)])
}
