% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan.R
\name{fprintf}
\alias{fprintf}
\alias{fprintf_raw}
\title{Print formatted strings to a connection}
\usage{
fprintf(con, fmt, ..., sep = "\\n", useBytes = FALSE)

fprintf_raw(con, fmt, ..., sep = "\\n", useBytes = FALSE)
}
\arguments{
\item{con}{Connection object or raw vector. When con is a raw vector, new
data will be \emph{appended} to the vector and returned.
Connection objects can be 
created with \code{file()}, \code{url()}, 
\code{rawConnection()} or any of the other many connection creation
functions.}

\item{fmt}{a character vector of format strings. See \code{\link{sprintf}()}}

\item{...}{values to be passed in to \code{fmt}. See \code{\link{sprintf}()}}

\item{sep}{If there are multiple strings to be printed, this separated will be 
written after each one.}

\item{useBytes}{See \code{\link{writeLines}()}}
}
\value{
If \code{con} is a connection then this connection is returned invisibly.
        If \code{con} is a raw vector then new data is appended to this vector
}
\description{
\code{fprintf_raw()} writes the text without a nul-terminator. \code{fprintf()}
writes a nul-terminator
}
\examples{
con <- rawConnection(raw(), "wb")
fprintf(con, "\%i,\%6.2f", 1, 3.14159)
close(con)
}
\seealso{
Other data output functions: 
\code{\link{write_f64}()},
\code{\link{write_hex}()},
\code{\link{write_raw}()},
\code{\link{write_uint8}()},
\code{\link{write_utf8}()}
}
\concept{data output functions}
