% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_devices.R
\name{get_devices}
\alias{get_devices}
\title{Get the devices or for a tenant.}
\usage{
get_devices(num_rows = NULL, parse_json = TRUE)
}
\arguments{
\item{num_rows}{The number of records to return.}

\item{parse_json}{If TRUE, parse the JSON object into a data frame.}
}
\value{
A \code{data.frame} if \code{parse_json = TRUE},
and a character string otherwise.
}
\description{
Get the devices or for a tenant.
}
\details{
Get the devices for a tenant.

If \code{num_rows = NULL} (default), all devices are returned.

If \code{parse_json} is TRUE, the JSON object is parsed using \code{jsonlite::fromJSON}
before being returned. The data is converted to a single flattened data frame.

If \code{parse_json} is FALSE, the JSON object is returned as a JSON string.
}
\examples{
\donttest{
get_devices()
}

}
\references{
\href{https://cumulocity.com/guides/reference/inventory/}{Cumulocity Inventory API}
}
\author{
Dmitriy Bolotov
}
