% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spikedCovarianceHelpers.R
\name{scaleEigVals}
\alias{scaleEigVals}
\title{Extract Estimated Scaled Eigenvalues in Spiked Covariance Matrix Model}
\usage{
scaleEigVals(eig_vals, noise, p_n_ratio, num_spikes)
}
\arguments{
\item{eig_vals}{A \code{numeric} vector of estimated eigenvalues.}

\item{noise}{\code{numeric} representing the known scalar multiple of the
identity matrix giving the approximate population covariance matrix.}

\item{p_n_ratio}{A \code{numeric} indicating the asymptotic ratio of the
number of features, p, and the number of observations, n. This ratio is
assumed to be between 0 and 1.}

\item{num_spikes}{\code{numeric} integer equal to or larger than one which
providing the known number of spikes in the population covariance matrix.
If set to \code{NULL}, the number of spikes is estimated.}
}
\value{
A \code{numeric} vector of the scaled eigenvalues to be shrunk.
}
\description{
\code{scaleEigVals()} computes the scaled eigenvalues, and
filters out all eigenvalues that do not need to be shrunk.
}
\keyword{internal}
