% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/awot.R
\name{awot}
\alias{awot}
\title{Adaptively weighted joint test for main effect and genotype-by-treatment interaction effect for continuous endpoints.}
\usage{
awot(nullmod, g, weights = seq(-1, 1, 0.1))
}
\arguments{
\item{nullmod}{- The null model object from the output of awot_null.}

\item{g}{- The variable of interest, e.g., the genotype.}

\item{weights}{- The pre-specified weights. The default choice is a vector of -1, -0.9,..., 0.9, 1.}
}
\value{
The p-value of AWOT and the individual p-values of the composite genotypes.
}
\description{
Adaptively weighted joint test for main effect and genotype-by-treatment interaction effect for continuous endpoints.
}
\examples{
n = 100
y = rbinom(n, 1, 0.3)
x = data.frame(x1=rnorm(n))
tr = rbinom(n, 1, 0.5)
g = rbinom(n, 2, 0.1)
nullmod = awot_null(y, tr, x)
awot(nullmod, g, weights=seq(-1,1,0.1))
}
\references{
Hong Zhang, Qing Li, Devan Mehrotra and Judong Shen. "CauchyCP: a powerful test under non-proportional hazards using Cauchy combination of change-point Cox regressions", arXiv:2101.00059.
}
