% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwot_null.R
\name{cwot_null}
\alias{cwot_null}
\title{Prepare null model for cwot.}
\usage{
cwot_null(y, tr, x = NULL)
}
\arguments{
\item{y}{- Binary response variable.}

\item{tr}{- Binary treatment variable, 1 for treated, 0 for placebo.}

\item{x}{- Covariates in addition to treatment variable.}
}
\value{
A list of objects needed for cwot.
}
\description{
Prepare null model for cwot.
}
\examples{
n = 100
y = rbinom(n, 1, 0.3)
x = data.frame(x1=rnorm(n))
tr = rbinom(n, 1, 0.5)
nullmod = cwot_null(y, tr, x)
}
\references{
Hong Zhang, Devan Mehrotra and Judong Shen, "AWOT and CWOT for Genotype and Genotype by Treatment Interaction Joint Analysis in Pharmacogenetics GWAS".
}
