% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{full2half_circ}
\alias{full2half_circ}
\title{Convert Angle from Full Circle to Half Circle}
\usage{
full2half_circ(angle)
}
\arguments{
\item{angle}{\link[base]{numeric} value of an angle or a
\code{\link[circular]{circular}}-object in \eqn{[0, 2\pi)}.}
}
\value{
The \link[base]{numeric} value of the angle in \eqn{[-\pi, \pi)}.
}
\description{
Converts an angle from the full circle (i.e. in the interval \eqn{[0, 2\pi)})
to an angle on the half circle  (i.e. in the interval \eqn{[-\pi, \pi)}).
}
\examples{
full2half_circ(0 * pi) / pi
full2half_circ(0.5 * pi) / pi
full2half_circ(1 * pi) / pi
full2half_circ(1.5 * pi) / pi
full2half_circ(2 * pi) / pi


}
