% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_ts}
\alias{plot_ts}
\title{Plot time series chart}
\usage{
plot_ts(x = NULL, y, label_x = "", label_y = "", color = "black")
}
\arguments{
\item{x}{time index (numeric vector) or NULL to use 1:length(y)}

\item{y}{numeric series}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{color}{color for the series}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Simple time series plot with points and a line.
}
\details{
If \code{x} is NULL, an integer index 1:n is used. The color applies to both points and line.
}
\examples{
x <- seq(0, 10, 0.25)
y <- sin(x)

grf <- plot_ts(x = x, y = y, color=c("red"))
plot(grf)
}
