% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDDM.R
\name{EDDM}
\alias{EDDM}
\title{EDDM (Early Drift Detection Method)}
\description{
This class implements the Early Drift Detection Method (EDDM), designed to detect
concept drifts in online learning scenarios by monitoring the distances between consecutive errors.
EDDM is particularly useful for detecting gradual drifts earlier than abrupt changes.
}
\details{
EDDM is a statistical process control method that is more sensitive to changes that happen
more slowly and can provide early warnings of deterioration before the error rate increases
significantly.
}
\examples{
set.seed(123)  # Setting a seed for reproducibility
data_part1 <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.7, 0.3))

# Introduce a change in data distribution
data_part2 <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.3, 0.7))

# Combine the two parts
data_stream <- c(data_part1, data_part2)
eddm <- EDDM$new()
for (i in 1:length(data_stream)) {
  eddm$add_element(data_stream[i])
  if (eddm$change_detected) {
    message(paste("Drift detected!",i))
  } else if (eddm$warning_detected) {
    message(paste("Warning detected!",i))
  }
}
}
\references{
Early Drift Detection Method. Manuel Baena-Garcia, Jose Del Campo-Avila,
Raúl Fidalgo, Albert Bifet, Ricard Gavalda, Rafael Morales-Bueno. In Fourth
International Workshop on Knowledge Discovery from Data Streams, 2006.

Implementation: https://github.com/scikit-multiflow/scikit-multiflow/blob/a7e316d1cc79988a6df40da35312e00f6c4eabb2/src/skmultiflow/drift_detection/eddm.py
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{eddm_warning}}{Warning threshold setting.}

\item{\code{eddm_outcontrol}}{Out-of-control threshold setting.}

\item{\code{m_num_errors}}{Current number of errors encountered.}

\item{\code{m_min_num_errors}}{Minimum number of errors to initialize drift detection.}

\item{\code{m_n}}{Total instances processed.}

\item{\code{m_d}}{Distance to the last error from the current instance.}

\item{\code{m_lastd}}{Distance to the previous error from the last error.}

\item{\code{m_mean}}{Mean of the distances between errors.}

\item{\code{m_std_temp}}{Temporary standard deviation accumulator for the distances.}

\item{\code{m_m2s_max}}{Maximum mean plus two standard deviations observed.}

\item{\code{delay}}{Delay count since the last detected change.}

\item{\code{estimation}}{Current estimated mean distance between errors.}

\item{\code{warning_detected}}{Boolean indicating if a warning has been detected.}

\item{\code{change_detected}}{Boolean indicating if a change has been detected.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-EDDM-new}{\code{EDDM$new()}}
\item \href{#method-EDDM-reset}{\code{EDDM$reset()}}
\item \href{#method-EDDM-add_element}{\code{EDDM$add_element()}}
\item \href{#method-EDDM-clone}{\code{EDDM$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EDDM-new"></a>}}
\if{latex}{\out{\hypertarget{method-EDDM-new}{}}}
\subsection{Method \code{new()}}{
Initializes the EDDM detector with specific parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EDDM$new(min_num_instances = 30, eddm_warning = 0.95, eddm_outcontrol = 0.9)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min_num_instances}}{Minimum number of errors before drift detection starts.}

\item{\code{eddm_warning}}{Threshold for warning level.}

\item{\code{eddm_outcontrol}}{Threshold for out-of-control level.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EDDM-reset"></a>}}
\if{latex}{\out{\hypertarget{method-EDDM-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the internal state of the EDDM detector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EDDM$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EDDM-add_element"></a>}}
\if{latex}{\out{\hypertarget{method-EDDM-add_element}{}}}
\subsection{Method \code{add_element()}}{
Adds a new observation and updates the drift detection status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EDDM$add_element(prediction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prediction}}{Numeric value representing a new error (usually 0 or 1).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EDDM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-EDDM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EDDM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
