% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C3FURV.R
\name{temporal_coherence}
\alias{temporal_coherence}
\title{Daily temporal coherence test}
\usage{
temporal_coherence(
  dailydata,
  meta = NULL,
  outpath,
  temp_jumps = 20,
  windspeed_jumps = 15,
  snowdepth_jumps = 50
)
}
\arguments{
\item{dailydata}{A character string giving the path of the input file,
or a 5-column matrix with following columns: variable code, year, month,
day, and the daily value.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{dailydata} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}

\item{temp_jumps}{given a daily maximum or minimum temperature values of two
consecutive days, maximum difference in degrees Celsius. By default, 
temp_jumps = 20 C.}

\item{windspeed_jumps}{given a daily mean wind speed value of two consecutive days,
maximum difference in metres per second. By default, wind_jumps = 15 m/s.}

\item{snowdepth_jumps}{given a daily snow depth of two consecutive days, 
maximum difference in centimetres. By default, snowdepth_jumps = 50 cm.}
}
\description{
Find those records where daily maximum or minimum temperature, 
mean wind speed, 
snow depth, snow cover, or fresh snow differences with previous day are too
large.
}
\details{
The input file must follow the Copernicus Station Exchange 
Format (SEF).
}
\examples{
temporal_coherence(Rosario$Tx, Meta$Tx, outpath = tempdir(), temp_jumps = 10)

}
\author{
Alba Gilabert, Yuri Brugnara
}
