% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/era-clim.R
\name{wmo_gross_errors}
\alias{wmo_gross_errors}
\title{WMO Gross Errors Tests for Pressure, Temperature, Dew Point, and Wind Speed.}
\usage{
wmo_gross_errors(series, meta = NULL, outpath)
}
\arguments{
\item{series}{A character string giving the path of the SEF file, or a
five or seven-column (daily or subdaily) data frame with the series.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{series} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}
}
\description{
Applicable to a series (daily or sub-daily) of air pressure, air temperature (ta),
dew point temperature (td), wind speed (w).
The pressure series can be at mean sea level (mslp) or at station level (p). 
Flags the records where the observations values exceed the limit values given 
by WMO (1993).
}
\details{
\strong{Input:}
\itemize{
\item A SEF file or a data frame and metadata. The observations data frame
must have five or seven columns: variable code, year (YYYY), month (MM), day
(DD), (hour (HH), minute (MM)), observation. The required metadata are the
station identifier, the station latitude and variable units.
}
\strong{The WMO gross error limits for air pressure, air temperature, dew
point temperature, and wind speed:}
\itemize{
\item For station level pressure the gross error limits are latitude and
meteorological season independent (WMO, 1993: VI.7). According to the same
reference, for mean sea level pressure, temperature, dew point, and wind speed,
the WMO establishes the gross error limits as
function of the station latitude and the meteorological season in which the
observations were collected.
\item The tests divide the meteorological seasons in Winter and Summer. So,
based on the meteorological calendar for the Northern Hemisphere, which
defines seasons as Spring (March, April, May), Summer (June, July, August),
Autumn (September, October, November) and Winter (December, January,
February), it was here considered:
\itemize{
\item Northern Hemisphere Winter / Southern Hemisphere Summer - January,
February, March, October, November, December;
\item Northern Hemisphere Summer / Southern Hemisphere Winter  - April, May,
June, July, August, September.
}
\item The gross error limits for each variable divide the flagged values in
suspect and erroneous (WMO, 1993: VI.6 - VI.8).
\item \strong{Latitude independent}
\itemize{
\item \strong{Meteorological season independent}
\itemize{
\item \strong{Station Level Pressure (p):} 
\itemize{
\item Suspect: \emph{300 <= p < 400 hPa or 1080 < p <= 1100 hPa}
\item Erroneous: \emph{p < 300 or p > 1100 hPa}
}
}
}
\item \strong{Latitudes belonging to the interval [-45, +45]}
\itemize{
\item \strong{Winter}
\itemize{
\item \strong{Mean Sea Level Pressure (mslp)}
\itemize{
\item Suspect: \emph{870 <= mslp < 910 hPa or 1080 < mslp <= 1100 hPa}
\item Erroneous: \emph{mslp < 870 hPa or mslp > 1100 hPa}
}
\item \strong{Air Temperature (ta)}
\itemize{
\item Suspect: \emph{-40 <= ta < -30 ºC or 50 < ta <= 55 ºC}
\item Erroneous: \emph{ta < -40 ºC or ta > 55 ºC}
}
\item \strong{Dew Point Temperature (td)}
\itemize{
\item Suspect: \emph{-45 <= td < -35 ºC or 35 < td <= 40 ºC}
\item Erroneous: \emph{td < -45 ºC or td > 40 ºC}
}
\item \strong{Wind Speed (w)}
\itemize{
\item Suspect: \emph{w > 60 m/s and w <= 125 m/s}
\item Erroneous: \emph{w > 125 m/s}
}
}
\item \strong{Summer}
\itemize{
\item \strong{Mean Sea Level Pressure (mslp)}
\itemize{
\item Suspect: \emph{850 <= mslp < 900 hPa or 1080 < mslp <= 1100 hPa}
\item Erroneous: \emph{mslp < 850 hPa or mslp > 1100 hPa}
}
\item \strong{Air Temperature (ta)}
\itemize{
\item Suspect: \emph{-30 <= ta < -20 ºC or 50 < ta <= 60 ºC}
\item Erroneous: \emph{ta < -30 ºC or ta > 60 ºC}
}
\item \strong{Dew Point Temperature (td)}
\itemize{
\item Suspect: \emph{-35 <= td < -25 ºC or 35 < td <= 40 ºC}
\item Erroneous: \emph{td < -35 ºC or td > 40 ºC}
}
\item \strong{Wind Speed (w)}
\itemize{
\item Suspect: \emph{w > 90 m/s and w <= 150 m/s}
\item Erroneous: \emph{w > 150 m/s}
}
}
}
\item \strong{Latitudes belonging to the interval [-90, -45[ U ]+45, +90]}
\itemize{
\item \strong{Winter}
\itemize{
\item \strong{Mean Sea Level Pressure (mslp)}
\itemize{
\item Suspect: \emph{910 <= mslp < 940 hPa or 1080 < mslp <= 1100 hPa}
\item Erroneous: \emph{mslp < 910 hPa or mslp > 1100 hPa}
}
\item \strong{Air Temperature (ta)}
\itemize{
\item Suspect: \emph{-90 <= ta < -80 ºC or 35 < ta <= 40 ºC}
\item Erroneous: \emph{ta < -90 ºC or ta > 40 ºC}
}
\item \strong{Dew Point Temperature (td)}
\itemize{
\item Suspect: \emph{-99 <= td < -85 ºC or 30 < td <= 35 ºC}
\item Erroneous: \emph{td < -99 ºC or td > 35 ºC}
}
\item \strong{Wind Speed (w)}
\itemize{
\item Suspect: \emph{w > 50 m/s and w <= 100 m/s}
\item Erroneous: \emph{w > 100 m/s}
}
}
\item \strong{Summer}
\itemize{
\item \strong{Mean Sea Level Pressure (mslp)}
\itemize{
\item Suspect: \emph{920 <= mslp < 950 hPa or 1080 < mslp <= 1100 hPa}
\item Erroneous: \emph{mslp < 920 hPa or mslp > 1100 hPa}
}
\item \strong{Air Temperature (ta)}
\itemize{
\item Suspect: \emph{-40 <= ta < -30 ºC or 40 < ta <= 50 ºC}
\item Erroneous: \emph{ta < -40 ºC or ta > 50 ºC}
}
\item \strong{Dew Point Temperature (td)}
\itemize{
\item Suspect: \emph{-45 <= td < -35 ºC or 35 < td <= 40 ºC}
\item Erroneous: \emph{td < -45 ºC or td > 40 ºC}
}
\item \strong{Wind Speed (w)}
\itemize{
\item Suspect values: \emph{w > 40 m/s and w <= 75 m/s}
\item Erroneous values: \emph{w > 75 m/s}
}
}
}
}
\strong{Output:}
\itemize{
\item A text file of flagged observations with six or eight columns: variable
code, year (YYYY), month (MM), day (DD), (hour (HH), minute (MM)),
observation, test. The test column has the description "gross_errors".
}
}
\examples{
wmo_gross_errors(series = Rosario$p, meta = Meta$p[which(Meta$p$id=="Rosario"),],
                 outpath = tempdir())
wmo_gross_errors(series = Rosario$ta, meta = Meta$ta[which(Meta$p$id=="Rosario"),],
                 outpath = tempdir())
wmo_gross_errors(series = Rosario$td, meta = Meta$td, outpath = tempdir())

}
\references{
WMO, 1993: Chapter 6 - Quality Control Procedures. Guide on the Global
Data-processing System, World Meteorological Organization, Geneva, No. 305,
VI.1-VI.27, ISBN 92-63-13305-0.
}
\author{
Clara Ventura, Yuri Brugnara
}
