#'Weight Loss Score Data for Three-way Repeated Measures ANOVA
#'
#'@description A researcher wanted to assess the effects of Diet and Exercises
#'  on weight loss in 10 sedentary males.
#'
#'  The participants were enrolled in four trials: (1) no diet and no exercises;
#'  (2) diet only; (3) exercises only; and (4) diet and exercises combined.
#'
#'  Each participant performed all four trials. The order of the trials was
#'  counterbalanced and sufficient time was allowed between trials to allow any
#'  effects of previous trials to have dissipated (i.e., a "wash out" period).
#'
#'  Each trial lasted nine weeks and the weight loss score was measured at the
#'  beginning of each trial (t1), at the midpoint of each trial (t2) and at the
#'  end of each trial (t3).
#'
#'  Three-way repeated measures ANOVA can be performed in order to determine
#'  whether there is interaction between diet, exercises and time on the weight
#'  loss score.
#'@name weightloss
#'@docType data
#'@usage data("weightloss")
#'@format A data frame with 48 rows and 6 columns.
#' @examples
#' data(weightloss)
#' head(as.data.frame(weightloss))
NULL
