% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heartattack.R
\docType{data}
\name{heartattack}
\alias{heartattack}
\title{Heart Attack Data for Three Way ANOVA}
\format{A data frame with 72 rows and 5 columns.}
\usage{
data("heartattack")
}
\description{
Measures of cholesterol concentration in 72 participants treated
 with three different drugs. The aim is to examine the potential of new class
 of drugs in lowering the cholesterol concentration and consequently reducing
 heart attack.

 The participants include 36 males and 36 females. Males and
 females were further (equally) subdivided into whether they were at low or
 high risk of heart attack.

 This data set is suited for three way Anova test.

 It contain the following variables: \itemize{ \item gender, which has two
 categories: "male" and "female"; \item risk which has two levels: "low" and
 "high"
 \item drug, which has three categories: "A", "B" and "C".
 }
}
\examples{
data(heartattack)
head(as.data.frame(heartattack))
}
