
<!-- README.md is generated from README.Rmd. Please edit that file -->

# dcmdata <a href="https://dcmdata.r-dcm.org"><img src="man/figures/logo.png" align="right" height="138" alt="dcmdata website" /></a>

<!-- badges: start -->

[![Project Status: Active – The project has reached a stable, usable
state and is being actively
developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![lifecycle](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html)
[![R package
version](https://www.r-pkg.org/badges/version/dcmdata)](https://cran.r-project.org/package=measr)
[![Package
downloads](https://cranlogs.r-pkg.org/badges/grand-total/dcmdata)](https://cran.r-project.org/package=measr)</br>
[![R-CMD-check](https://github.com/r-dcm/dcmdata/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/r-dcm/dcmdata/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/r-dcm/dcmdata/branch/main/graph/badge.svg)](https://app.codecov.io/gh/r-dcm/dcmdata?branch=main)
[![GitHub
pages](https://github.com/r-dcm/dcmdata/actions/workflows/pkgdown.yaml/badge.svg)](https://github.com/r-dcm/dcmdata/actions/workflows/pkgdown.yaml)</br>
[![Signed
by](https://img.shields.io/badge/Keybase-Verified-brightgreen.svg)](https://keybase.io/wjakethompson)
![License](https://img.shields.io/badge/License-MIT-blue.svg)
<!-- badges: end -->

The goal of dcmdata is to provide easy access to data sets for use with
diagnostic classification models.

## Installation

You can install the released version of dcmdata from
[CRAN](https://cran.r-project.org/) with:

``` r
install.packages("dcmdata")
```

And the development version from [GitHub](https://github.com/) with:

``` r
# install.packages("pak")
pak::pak("r-dcm/dcmdata")
```

## About the data

dcmdata contains both real and simulated data sets for educational and
psychological assessment. For more information on each data set, see the
linked reference pages.

### Real data sets

- [ECPE](https://dcmdata.r-dcm.org/reference/ecpe.html): Assessment data
  from the Examination for the Certificate of Proficiency in English, as
  described in [Templin and Hoffman
  (2013)](https://doi.org/10.1111/emip.12010).
- [MDM](https://dcmdata.r-dcm.org/reference/mdm.html): A short integer
  multiplication assessment, as described in [MacReady and Dayton
  (1977)](https://doi.org/10.2307/1164802).

### Simulated data sets

- [DTMR](https://dcmdata.r-dcm.org/reference/dtmr.html): A data set
  based on the Diagnostic Teachers’ Multiplicative Reasoning assessment,
  described in [Bradshaw et
  al. (2014)](https://doi.org/10.1111/emip.12020).

------------------------------------------------------------------------

## Contributions and Code of Conduct

Contributions are welcome. To ensure a smooth process, please review the
[Contributing Guide](https://dcmdata.r-dcm.org/CONTRIBUTING.html).
Please note that the dcmdata project is released with a [Contributor
Code of Conduct](https://dcmdata.r-dcm.org/CODE_OF_CONDUCT.html). By
contributing to this project, you agree to abide by its terms.
