% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.dcsvm.R
\name{print.dcsvm}
\alias{print.dcsvm}
\title{Print a DCSVM Object}
\usage{
\method{print}{dcsvm}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{A fitted \code{\link{dcsvm}} object.}

\item{digits}{Specifies the significant digits to use in the output. Default is \code{max(3, getOption("digits") - 3)}.}

\item{...}{Additional arguments to \code{print}.}
}
\value{
A two-column matrix with one column showing the number of nonzero coefficients and the other column showing the \code{lambda} values.
}
\description{
Prints a summary of the \code{dcsvm} object, showing the solution paths.
}
\details{
Print a DCSVM Object

Print a summary of the \code{\link{dcsvm}} solution paths.


This function prints a two-column matrix with columns \code{Df} and \code{Lambda}. The \code{Df} column shows the number of nonzero coefficients, and the \code{Lambda} column displays the corresponding \code{lambda} value. It is adapted from the \code{print} function in the \code{gcdnet} and \code{glmnet} packages.
}
\examples{
data(colon)
fit <- dcsvm(colon$x, colon$y)
print(fit)

}
\seealso{
\code{print.dcsvm}, \code{predict.dcsvm}, \code{coef.dcsvm}, \code{plot.dcsvm}, and \code{cv.dcsvm}.
}
