% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casting.R
\name{cast-lsd}
\alias{cast-lsd}
\alias{deb_as_lsd}
\alias{deb_as_lsd.default}
\alias{deb_as_lsd.deb_lsd}
\alias{deb_as_lsd.deb_decimal}
\alias{deb_as_lsd.deb_tetra}
\alias{deb_as_lsd.numeric}
\alias{deb_as_lsd.logical}
\alias{deb_as_lsd.list}
\title{Cast to \code{deb_lsd}}
\usage{
deb_as_lsd(x, ...)

\method{deb_as_lsd}{default}(x, ...)

\method{deb_as_lsd}{deb_lsd}(x, ...)

\method{deb_as_lsd}{deb_decimal}(x, ...)

\method{deb_as_lsd}{deb_tetra}(x, ...)

\method{deb_as_lsd}{numeric}(x, bases = c(20, 12), ...)

\method{deb_as_lsd}{logical}(x, bases = c(20, 12), ...)

\method{deb_as_lsd}{list}(x, bases = c(20, 12), ...)
}
\arguments{
\item{x}{An object to coerce to \code{deb_lsd}.}

\item{...}{Arguments passed on to further methods.}

\item{bases}{Numeric vector of length 2 used to specify the bases for the
solidus or s and denarius or d units. Default is \code{c(20, 12)}, which
conforms to the most widely used system of 1 pound = 20 shillings and
1 shilling = 12 pence.}
}
\value{
A \code{deb_lsd} vector.
}
\description{
Cast \code{x} to a \code{deb_lsd} vector.
}
\details{
Casting a list of numeric vectors of length 3 to \code{deb_lsd}
provides an alternate way to create a \code{deb_lsd} vector than \code{\link[=deb_lsd]{deb_lsd()}}.
This method may be helpful because the data is input by the value instead
of by the unit.
}
\examples{

# Cast a deb_decimal vector to deb_lsd
x <- c(5.825, 3.25, 22/3)
d1 <- deb_decimal(x)
deb_as_lsd(d1)

# Bases are automatically applied when
# casting from deb_decimal to deb_lsd
d2 <- deb_decimal(x, bases = c(60, 16))
deb_as_lsd(d2)

# Cast a deb_tetra vector to deb_lsd
# This removes the 'f' or farthings unit.
y <- deb_tetra(l = c(5, 13, 7),
               s = c(12, 8, 16),
               d = c(3, 11, 0),
               f = c(1, 3, 2))
deb_as_lsd(y)

# Cast a numeric vector to deb_lsd
deb_as_lsd(x)

# Use the bases argument to apply non-default bases
deb_as_lsd(x, bases = c(60, 16))

# Casting a list to deb_lsd provides an alternate to deb_lsd()
# This can be helpful for legibility. Compare:

deb_as_lsd(
  list(c(5, 12, 3),
       c(13, 8, 11),
       c(7, 16, 0))
  )

deb_lsd(l = c(5, 13, 7),
        s = c(12, 8, 16),
        d = c(3, 11, 0))

}
\seealso{
\code{\link[=deb_as_decimal]{deb_as_decimal()}} and \code{\link[=deb_as_tetra]{deb_as_tetra()}}
}
