% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_eml_tibble.R
\name{as_eml_tibble}
\alias{as_eml_tibble}
\alias{as_eml_tibble.tbl_df}
\alias{as_eml_tibble.tbl_lp}
\alias{as_eml_tibble.list}
\alias{as_eml_tibble.xml_document}
\title{Convert metadata to a \code{tibble}}
\usage{
as_eml_tibble(x, ...)

\method{as_eml_tibble}{tbl_df}(x, ...)

\method{as_eml_tibble}{tbl_lp}(x, ...)

\method{as_eml_tibble}{list}(x, ...)

\method{as_eml_tibble}{xml_document}(x, ...)
}
\arguments{
\item{x}{Object to be converted}

\item{...}{Other arguments, currently ignored}
}
\value{
An object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, containing
the following fields:
\itemize{
\item \code{level} (int) gives the nestedness level of the node/heading in question
\item \code{label} (chr) the \code{xml} tag
\item \code{text} (chr) Any text stored within that tag
\item \code{attributes} (list) Any attributes for that tag
}
}
\description{
Takes objects of class \code{list} or \code{xml_document} and converts
them to a tibble with a particular structure, designed for storing nested
data. Tibbles are required because attributes are stored as list-columns,
which are not supported by class \code{data.frame}.
}
\examples{
source_file <- system.file("extdata", 
                           "bionet_metadata.xml",
                           package = "delma")
xml_data <- xml2::read_xml(source_file)
as_eml_tibble(xml_data)
}
