% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_lp_tibble.R
\name{as_lp_tibble}
\alias{as_lp_tibble}
\alias{as_lp_tibble.tbl_lp}
\alias{as_lp_tibble.tbl_df}
\alias{as_lp_tibble.list}
\alias{as_lp_tibble.xml_document}
\title{Convert metadata to a lightparser \code{tibble}}
\usage{
as_lp_tibble(x, ...)

\method{as_lp_tibble}{tbl_lp}(x, ...)

\method{as_lp_tibble}{tbl_df}(x, ...)

\method{as_lp_tibble}{list}(x, ...)

\method{as_lp_tibble}{xml_document}(x, ...)
}
\arguments{
\item{x}{Object to be converted.}

\item{...}{Other arguments, currently ignored.}
}
\value{
An object of class \code{tbl_lp}, \code{tbl_df}, \code{tbl} and \code{data.frame}, containing
the following fields:
\itemize{
\item \code{type} (chr) Whether that section is e.g. YAML, inline text, heading, or code block
\item \code{label} (chr) The tag associated with a given code block (otherwise NA)
\item \code{params} (list) Attributes of a code block
\item \code{text} (list) Any text in that section
\item \code{code} (list) Any code in that section
\item \code{heading} (chr) For \code{type} = \code{heading}, the value of that heading
\item \code{heading_level} (dbl) The heading level of that heading (i.e. number of \verb{#})
\item \code{section} (chr) The heading this section sits within
}
}
\description{
Takes objects of class \code{tbl_df}, \code{list} or \code{xml_document} and converts
them to a tibble with a structure required by \code{lightparser}. Note that
\code{delma} represents these as an object of class \code{tbl_lp} for convenience.
}
\examples{
source_file <- system.file("extdata", 
                           "bionet_metadata.xml",
                           package = "delma")
xml_data <- xml2::read_xml(source_file)
as_lp_tibble(xml_data)
}
