% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_mat_overlap.R
\name{cor_mat_overlap}
\alias{cor_mat_overlap}
\title{Pearson correlation matrix}
\usage{
cor_mat_overlap(x, y, minoverlap)
}
\arguments{
\item{x}{rwl object of tree-ring series}

\item{y}{rwl object of tree-ring series}

\item{minoverlap}{the correlation will only be calculated if the number of overlapping tree-rings is equal or larger than this value}
}
\value{
a list with two matrices: one with the correlation values and one with the number of overlapping tree rings for each correlation value. The matrices have row names and column names of the compared tree-ring curves
}
\description{
Function that creates a Pearson correlation matrix of two rwl objects compared. If the same rwl-object is passed to the function, the correlation between all series is calculated. In addition, the number of overlapping tree-rings is part of the output. The results can be used to calculate the Students' t value.
}
\details{
The function is an adaptation of the function cor.with.limit.R() from https://github.com/AndyBunn/dplR/blob/master/R/rwi.stats.running.R. The new function is optimized and also outputs the number of overlapping rings.
}
\examples{
rwl_object1 <- hol_rom
rwl_object2 <- hol_rom
cor_mat_overlap(rwl_object1, rwl_object2, 50)
cor_mat_overlap(rwl_object1, rwl_object1, 50)

}
\author{
Andy Bunn

Ronald Visser
}
