% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_area.R
\name{density_area}
\alias{density_area}
\title{Density Area}
\usage{
density_area(
  x,
  y,
  probs = 0.5,
  as_sf = FALSE,
  as_list = FALSE,
  range_mult = 0.25,
  rangex = NULL,
  rangey = NULL,
  ...
)
}
\arguments{
\item{x, y}{Numeric data dimensions}

\item{probs}{Probabilities to compute density polygons for}

\item{as_sf}{Should the returned values be \link[sf:sf]{sf::sf}? Defaults to \code{FALSE}.}

\item{as_list}{Should the returned value be a list? Defaults to \code{TRUE} to
work well with tidyverse list columns}

\item{range_mult}{A multiplier to the range of \code{x} and \code{y} across which the
probability density will be estimated.}

\item{rangex, rangey}{Custom ranges across \code{x} and \code{y} ranges across which the
probability density will be estimated.}

\item{...}{Additional arguments to be passed to \code{\link[ggdensity:get_hdr]{ggdensity::get_hdr()}}}
}
\value{
A list of data frames, if \code{as_list=TRUE}, or just a data frame,
if \code{as_list=FALSE}.
\subsection{Data frame output}{

If \code{as_sf=FALSE}, the data frame has the following columns:
\describe{
\item{level_id}{An integer id for each probability level}
\item{prob}{The probability level (originally passed to \code{probs})}
\item{area}{The area of the HDR polygon}
}
}

\subsection{sf output}{

If \code{as_sf=TRUE}, the data frame has the following columns:
\describe{
\item{level_id}{An integer id for each probability level}
\item{prob}{The probability level (originally passed to \code{probs})}
\item{geometry}{The \code{sf::st_polygon()} of the HDR}
\item{area}{The area of the HDR polygon}
}
}
}
\description{
A convenience function to get just the areas of density polygons.
}
\details{
If both \code{rangex} and \code{rangey} are defined, \code{range_mult} will be disregarded.
If only one or the other of \code{rangex} and \code{rangey} are defined, \code{range_mult}
will be used to produce the range of the undefined one.
}
\examples{
library(densityarea)
library(dplyr)
library(sf)

ggplot2_inst <- require(ggplot2)

# basic usage

set.seed(10)
x <- rnorm(100)
y <- rnorm(100)

density_area(x,
             y,
             probs = ppoints(50)) ->
  poly_areas_df

head(poly_areas_df)

# Plotting the relationship between probability level and area
if(ggplot2_inst){
  ggplot(poly_areas_df,
         aes(prob, area)) +
    geom_line()
}

# Tidyverse usage

data(s01)

## Data preprocessing

s01 |>
  mutate(log_F2 = -log(F2),
         log_F1 = -log(F1)) ->
  s01

### Data frame output

s01 |>
  group_by(name) |>
  reframe(density_area(log_F2,
                       log_F1,
                       probs = ppoints(10))) ->
  s01_areas_df

if(ggplot2_inst){
  s01_areas_df |>
    ggplot(aes(prob, area)) +
    geom_line()
}

### Including sf output

s01 |>
  group_by(name) |>
  reframe(density_area(log_F2,
                       log_F1,
                       probs = ppoints(10),
                       as_sf = TRUE)) |>
  st_sf() ->
  s01_areas_sf

if(ggplot2_inst){
  s01_areas_sf |>
    arrange(desc(prob)) |>
    ggplot() +
    geom_sf(aes(fill = area))
}
}
