% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packdepcoeff.R
\name{zetaci}
\alias{zetaci}
\title{Zeta coefficient of piecewise monotonicity with split domain}
\usage{
zetaci(x,y,a,method="Spearman",methodF=1,parH=0.5,parp=1.5)
}
\arguments{
\item{x, y}{data vectors of the two variables whose dependence is analysed.}

\item{a}{vector of fractions \eqn{a_{i},0<a_{i}<a_{i+1}<1} for the splitting. A fraction
of \eqn{a_{1},a_{2}-a_{1},a_{3}-a{2}}... of data points are in the corresponding split region.
The number of split regions is equal to the length of \eqn{a} plus 1.}

\item{method}{value (default "Spearman")}

\item{methodF}{value 1,2 or 3 refers to several methods for computation of
the distribution function values, 1 is the default value.}

\item{parH}{parameter of the Huber function (default 0.5). Valid values for
parH are between 0 and 1.}

\item{parp}{parameter of the power function (default 1.5). The parameter has
to be positive.}
}
\value{
list of zeta dependence coefficients of piecewise monotonicity of two
random variables containing the following elements:
  Spearman...Spearman coefficient
  footrule...Spearman's footrule
  power...power coefficient
  Huber...Huber function coefficient
}
\description{
The function zetaci evaluates the coefficient of piecewise monotonicity of variables x and y where the x-domain
is split into a fixed number of intervals.
}
\details{
Let \eqn{X_{1},\ldots ,X_{n}} be the sample of the \eqn{X} variable. Formulas
for the estimators of values \eqn{F(X_{i})} of the distribution function:
  methodF = 1 \eqn{\rightarrow \hat{F}(X_{i})=\frac{1}{n}\textrm{rank}(X_{i})}
  methodF = 2 \eqn{\rightarrow \hat{F}^{1}(X_{i})=\frac{1}{n+1}\textrm{rank}(X_{i})}
  methodF = 3 \eqn{\rightarrow \hat{F}^{2}(X_{i})=\frac{1}{\sqrt{n^{2}-1}}\textrm{rank}(X_{i})}
The values of the distribution function of \eqn{Y} are treated analogously.
}
\examples{
library(MASS)
data<- gilgais
zetaci(data[, 1], data[, 2], a=c(0.25, 0.5, 0.75))
}
\references{
Eckhard Liebscher (2017). Copula-based dependence measures for piecewise
monotonicity. Dependence Modeling 5 (2017), 198-220
}
