% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-plots.R
\name{ds_plot_box_group}
\alias{ds_plot_box_group}
\title{Compare distributions}
\usage{
ds_plot_box_group(data, ..., print_plot = TRUE)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble}.}

\item{...}{Column(s) in \code{data}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\description{
Creates box plots if the data has both categorical & continuous variables.
}
\examples{
# subset data
mt <- dplyr::select(mtcarz, cyl, disp, mpg)

# plot select variables
ds_plot_box_group(mtcarz, cyl, gear, mpg)

# plot all variables
ds_plot_box_group(mt)

}
