% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tod.r
\name{as.tod}
\alias{as.tod}
\alias{as.tod.character}
\alias{as.tod.circular}
\alias{is.tod}
\alias{as.double.tod}
\alias{circular}
\alias{circular.default}
\alias{circular.tod}
\title{Conversion to and from 'Time of Day'}
\usage{
as.tod(x)

\method{as.tod}{character}(x)

\method{as.tod}{circular}(x)

is.tod(x)

\method{as.double}{tod}(x, ...)

circular(x, ...)

\method{circular}{default}(
  x,
  type = c("angles", "directions"),
  units = c("radians", "degrees", "hours"),
  template = c("none", "geographics", "clock12", "clock24"),
  modulo = c("asis", "2pi", "pi"),
  zero = 0,
  rotation = c("counter", "clock"),
  names = NULL,
  ...
)

\method{circular}{tod}(x, ...)
}
\arguments{
\item{x}{An object to be converted to or represented as a circular object.}

\item{...}{Additional arguments passed to methods or lower-level functions.}

\item{type}{Character string indicating if data represent "angles" or "directions".}

\item{units}{Character string; the measurement units for the input data (\code{"radians"}, \code{"degrees"}, or \code{"hours"}).}

\item{template}{Character string specifying a specific template for circular data.}

\item{modulo}{Character string indicating the modulo arithmetic to be used (\code{"asis"}, \code{"2pi"}, \code{"pi"}).}

\item{zero}{Numeric; direction assigned as zero (in the specified units).}

\item{rotation}{Character string; direction of rotation for increasing values (\code{"counter"}, \code{"clock"}).}

\item{names}{Optional character vector of names for the object.}
}
\value{
x converted to/from 'tod'
}
\description{
Does not safeguard against "26:69".
}
\examples{
times <- c("8:53", NA, "22:30")

## some conversions
as.tod(times)
as.numeric(as.tod(times))

is.tod(times)
is.tod(as.tod(times))
}
\author{
Dr. Andreas Leha
}
