% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_InbreedingChr}
\alias{plot_InbreedingChr}
\title{Plot Froh-based inbreeding coefficients by group}
\usage{
plot_InbreedingChr(runs, mapFile, groupSplit = TRUE,
  style = c("ChrBarPlot", "ChrBoxPlot", "FrohBoxPlot", "All"),
  outputName = NULL, plotTitle = NULL, savePlots = FALSE)
}
\arguments{
\item{runs}{R object (dataframe) with results on detected runs}

\item{mapFile}{Plink map file (for SNP position)}

\item{groupSplit}{plots split by group (defaults to TRUE)}

\item{style}{type of plot: ChrBarPlot, ChrBoxPlot, FrohBoxPlot, All (all plots)}

\item{outputName}{title prefix (the base name of graph, if savePlots is TRUE)}

\item{plotTitle}{title in plot (default NULL)}

\item{savePlots}{should plots be saved out to files or plotted in the graphical terminal (default)?}
}
\value{
plots of the distribution of inbreeding by chromosome and group
}
\description{
The function plots the distribution of inbreeding/consanguinity coefficients
per chromosome and/or group. Three types of plots can be produces: barplots, boxplots,
violin plots. With \code{style="All"} all three plots are produced.
}
\examples{
# getting map and ped paths
genotypeFile <- system.file("extdata", "Kijas2016_Sheep_subset.ped", package = "detectRUNS")
mapFile <- system.file("extdata", "Kijas2016_Sheep_subset.map", package = "detectRUNS")

# calculating runs of Homozygosity
\dontrun{
# skipping runs calculation
runs <- slidingRUNS.run(genotypeFile, mapFile, windowSize = 15, threshold = 0.1,  minSNP = 15,
ROHet = FALSE,  maxOppositeGenotype = 1, maxMiss = 1,  minLengthBps = 100000,  minDensity = 1/10000)
}
# loading pre-calculated data
runsFile <- system.file("extdata", "Kijas2016_Sheep_subset.sliding.csv", package="detectRUNS")
runsDF <- readExternalRuns(inputFile = runsFile, program = 'detectRUNS')

plot_InbreedingChr(runs = runsDF, mapFile = mapFile, style='All')

}
