% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFuncs.R
\name{checkCharVec}
\alias{checkCharVec}
\title{Checking if all elements of a list are all character vectors}
\usage{
checkCharVec(listChar, namesListElements = NULL)
}
\arguments{
\item{listChar}{A list of the vectors of which one wishes to check if their data type is character}

\item{namesListElements}{Character vector containing the names of the variables of which the data type is checked. Optional parameter, with as default value NULL. This argument should be used when the variable of which the data type is checked is not an object that was provided as an argument to the function, or when the list elements of the first argument do not have a name attached to it.}
}
\value{
No value is returned if all vectors have the character data type. If not, an error message is thrown for each element of the list that does not pertain to the character data type.
}
\description{
Checking if all elements of a list are all character vectors
}
\examples{
arg1 <- 'something'
checkCharVec(list(arg1))

\donttest{checkCharVec(list('somethingElse', TRUE))

arg2 <- 2
checkCharVec(list(arg2))
checkCharVec(list(arg2, TRUE, 5L))}
}
