% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFuncs.R
\name{checkNumOrIntVec}
\alias{checkNumOrIntVec}
\title{Checking if all elements of a list are all integer or numeric vectors}
\usage{
checkNumOrIntVec(listNumOrInt, namesListElements = NULL)
}
\arguments{
\item{listNumOrInt}{A list of the vectors of which one wishes to check if their data type is integer.}

\item{namesListElements}{Character vector containing the names of the variables of which the data type is checked. Optional parameter, with as default value NULL. This argument should be used when the variable of which the data type is checked is not an object that was provided as an argument to the function, or when the list elements of the first argument do not have a name attached to it.}
}
\value{
No value is returned if all vectors have the integer or numeric data type. If not, an error message is thrown for each element of the list that does not pertain to the integer or numeric data type.
}
\description{
Checking if all elements of a list are all integer or numeric vectors
}
\examples{
arg1 <- 1L
checkNumOrIntVec(list(arg1))

arg1 <- 1
checkNumOrIntVec(list(arg1))

\donttest{checkNumOrIntVec(list(1L, TRUE, 2L))
checkNumOrIntVec(list(1L, TRUE, 2L), c('Var1', 'Var2', 'Var3'))

arg2 <- 'R'
checkNumOrIntVec(list(arg2))
checkNumOrIntVec(list(arg2, TRUE, 2))}
}
