% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_index.R
\name{pb_index}
\alias{pb_index}
\title{Bilateral Price Indexes}
\usage{
pb_index(df, p, qty, id, tm, typ = "f", seq = "ch", bsk = "flx")
}
\arguments{
\item{df}{A data frame sorted by the time period column.}

\item{p}{A string indicating the price column.}

\item{qty}{A string indicating the quantity column.}

\item{id}{A string indicating the identity column.}

\item{tm}{A string indicating the time period column. Each period must
contain two observations at least.}

\item{typ}{Relevant types of price indexes. Options include "f"
for Fisher price indexes (by default), "t" for Tornqvist price indexes,
"l" for Laspeyres price indexes, and "p" for Paasche price indexes.}

\item{seq}{Index construction sequences when the number of periods
is larger than 2. Options include "ch" for chained indexes (by default),
and "fb" for fixed base indexes.}

\item{bsk}{The choice of baskets when items are not matched over
multiple periods. Options include "flx" (by default) for a flexible basket
that varies depending on the maximal number of matched items in
two periods each time, and "cst" for a constant basket
that takes the maximal number of matched items across all periods.}
}
\value{
A data frame consisting of the time period and price indexes.
}
\description{
Bilateral indexes refer to the case when only two periods are
compared each time. \code{pb_index()} computes price indexes in a
bilateral approach.
}
\examples{
# Use the built-in data set "prices"
# Laspeyres fixed base indexes with a constant basket
df <- prices[[1]]
df <- df[order(df[,"t"]),]
index1 <- pb_index(df, "p", "q", "id", "t", typ = "l", seq = "fb", bsk = "cst")
# Fisher chained indexes with a flexible basket
df <- prices[[2]]
df <- df[order(df[,"t"]),]
index2 <- pb_index(df, "p", "q", "id", "t")
}
