% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_weight.R
\name{t_weight}
\alias{t_weight}
\title{Aggregation over Sectors with a Weighted Average Approach}
\usage{
t_weight(y, p, id, t, alpha, beta, gamma, epsilon, tau, data)
}
\arguments{
\item{y}{A string (or a vector of strings) indicating the output quantity columns.}

\item{p}{A string (or a vector of strings) indicating the output price columns.}

\item{id}{A string indicating the industry column.}

\item{t}{A string indicating the time period column.}

\item{alpha}{A string indicating net output price indexes.}

\item{beta}{A string indicating input quantity indexes.}

\item{gamma}{A string indicating input mixe indexes.}

\item{epsilon}{A string indicating value added efficiency indexes.}

\item{tau}{A string indicating technical progress indexes.}

\item{data}{A data frame containing input prices, input quantities,
industry identities, the time period, and explanatory factors of
value added growth.}
}
\value{
A list containing a growth-value table and a level-value table of
explanatory factors for value added growth decomposition. It is
sorted by the time period.
}
\description{
This "bottom up" approach uses weighted averages of the
sectoral decompositions to provide an approximate
decomposition into explanatory components at the aggregate
level. Specifically, the Tornqvist index is adopted in the
aggregation.
}
\examples{
# Use the built-in dataset "sector"
table1 <- t_weight("y", "p", "industry", "year", "alpha",
        "beta", "gamma", "epsilon", "tau", sector)[[1]]
table2 <- t_weight("y", "p", "industry", "year", "alpha",
        "beta", "gamma", "epsilon", "tau", sector)[[2]]
}
\references{
Diewert, W. E. and Fox, K. J. (2018). Decomposing value added growth into explanatory
factors. In The Oxford Handbook of Productivity Analysis, chapter 19,
page 625--662. Oxford University Press: New York.
}
