% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HV_test.R
\name{HV_test}
\alias{HV_test}
\title{Homogeneity of Variance Tests for Linear L1 Models}
\usage{
HV_test(y, x, groups, alpha = 0.05, tolerance = 0.001, max_iteration = 2000)
}
\arguments{
\item{y}{A vector with response variables.}

\item{x}{A matrix with a single explanatory variable.}

\item{groups}{Vector containing the group index to which the observation belongs.}

\item{alpha}{Significance level of the test, must be between 0 and 1.}

\item{tolerance}{threshold that determines when the iterative algorithm should stop (for \code{regL1_het}).}

\item{max_iteration}{maximum number of iterations (for \code{regL1_het}).}
}
\value{
A list with results from 3 homogeneity of variance tests
\item{alpha}{alpha argument.}
\item{asymptotic_critical_value}{asymptotic alpha-based test critical value.}
\item{HV_LRT}{LF1 statistic value using MLE (Maximum Likelihood Estimator).}
\item{HV_max_lambda_ratio}{p-value of LF1 statistic using MLE.}
\item{HV_max_log_lambda_ratio}{LF1 statistic value using ROS (Residuals Order Statistics).}
\item{number_of_groups}{number of groups.}
\item{N}{overall sample size.}
\item{lambda_heteroscedastic}{heteroscedastic estimation of the scaling parameters.}
\item{lambda_homocedastic}{homoscedastic estimation of the scale parameter.}
}
\description{
Homogeneity of Variance Tests for Linear L1 Models
}
\details{
The 3 statistics to test homogeneity of variance are discussed in Rodrigues, Elian and Pereira (2025), for more details see this reference. In practice, use the HV_LRT statistic results. If possible, use the HV_LRT statistic with a critical value obtained via bootstrap simulation.
}
\examples{
\donttest{
set.seed(123)
x1 = matrix(rnorm(20), ncol = 1)
y1 = x1 + rlaplace(20, 0, 1)
x2 = matrix(rnorm(20), ncol = 1)
y2 = x2 + rlaplace(20, 0, 1.5)
x3 = matrix(rnorm(20), ncol = 1)
y3 = x3 + rlaplace(20, 0, 2)
x4 = matrix(rnorm(20), ncol = 1)
y4 = x4 + rlaplace(20, 0, 2.5)
x5 = matrix(rnorm(20), ncol = 1)
y5 = x5 + rlaplace(20, 0, 3)

y = c(y1, y2, y3, y4, y5)
x = rbind(x1, x2, x3, x4, x5)
group_index = c(rep(1,20),rep(2,20),rep(3,20),rep(4,20),rep(5,20))

# Application of the homogeneity of variance test
test_result = HV_test(y, x, group_index)
test_result
}

}
\references{
Rodrigues, K. A. S., Elian, S. N., & Pereira, G. H. A. (2025). Homoscedasticity tests for L1 regression and their performance evaluation through simulations. \emph{Statistics}, Advance online publication. https://doi.org/10.1080/02331888.2025.2536097

Rodrigues, K. A. S., & Elian, S. N. (2025). Influence measures for L1 regression: an analysis with the R package diagL1. \emph{Journal of Applied Statistics}, Advance online publication. https://doi.org/10.1080/02664763.2025.2510691
}
