% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regL1.R
\name{regL1}
\alias{regL1}
\title{Fitting Linear L1 Models}
\usage{
regL1(
  formula,
  data,
  subset,
  weights,
  na.action,
  method = "br",
  model = TRUE,
  contrasts = NULL,
  ...
)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~ operator, and the terms, separated by + operators, on the right.}

\item{data}{a data.frame in which to interpret the variables named in the formula, or in the subset and the weights argument. If this is missing, then the variables in the formula should be on the search list. This may also be a single number to handle some special cases – see below for details.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{weights}{vector of observation weights; if supplied, the algorithm fits to minimize the sum of the weights multiplied into the absolute residuals. The length of weights must be the same as the number of observations. The weights must be nonnegative and it is strongly recommended that they be strictly positive, since zero weights are ambiguous.}

\item{na.action}{a function to filter missing data. This is applied to the model.frame after any subset argument has been used. The default (with na.fail) is to create an error if any missing values are found. A possible alternative is na.omit, which deletes observations that contain one or more missing values.}

\item{method}{the algorithmic method used to compute the fit. There are several options: "br", "fn", "pfn", "sfn", "fnc", "conquer", "pfnb", "qfnb", "ppro" and "lasso". See \code{\link[quantreg]{rq}} for more details.}

\item{model}{if TRUE then the model frame is returned. This is essential if one wants to call summary subsequently.}

\item{contrasts}{a list giving contrasts for some or all of the factors default = NULL appearing in the model formula. The elements of the list should have the same name as the variable and should be either a contrast matrix (specifically, any full-rank matrix with as many rows as there are levels in the factor), or else a function to compute such a matrix given the number of levels.}

\item{...}{additional arguments for the fitting routines (see \code{\link[quantreg]{rq.fit.br}} and \code{\link[quantreg]{rq.fit.fnb}}, etc. and the functions they call).}
}
\value{
A fitted L1 linear regression model object.
}
\description{
This function fits an L1 regression model using the \code{\link[quantreg]{rq}} function from the 'quantreg' package. L1 regression allows dealing with outliers and non-normal distributions in the data.
}
\details{
L1 regression is an important particular case of quantile regression, so this function inherits from the "rq" class of the \code{quantreg} package.
}
\examples{
set.seed(123)
x = matrix(rnorm(100), ncol = 2)
y = x[, 1] + x[, 2] + rlaplace(50, 0, 5)

# Fits a linear regression L1 model
mod1 = regL1(y ~ x)

}
