% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{saveDifferentiationTreeToFile}
\alias{saveDifferentiationTreeToFile}
\title{Save the graphic representation of the differentiation tree.}
\usage{
saveDifferentiationTreeToFile(TESs, filename)
}
\arguments{
\item{TESs}{TES structure computed with \code{\link{getTESs}}.}

\item{filename}{Defines the filename for exporting the image of the differentiation tree. The only file extension accepted is "svg", filenames omitting the extensions and those with other extensions will be forced to SVG format.}
}
\value{
None
}
\description{
\code{saveDifferentiationTreeToFile} saves the image of the computed differentiation tree into a file.
}
\examples{

net <- BoolNet::generateRandomNKNetwork(10, 2)
attractors <- BoolNet::getAttractors(net)
ATM <- getATM(net, attractors)
TESs <- getTESs(ATM)
saveDifferentiationTreeToFile(TESs, tempfile(tmpdir = tempdir(), fileext = ".svg"))

}
