% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_mechanism.R
\docType{class}
\name{DPMechGaussian-class}
\alias{DPMechGaussian-class}
\alias{DPMechGaussian}
\alias{show,DPMechGaussian-method}
\title{An S4 class for the Gaussian mechanism of differential privacy.}
\usage{
\S4method{show}{DPMechGaussian}(object)
}
\arguments{
\item{object}{an instance of class \code{DPMech}.}
}
\description{
A class that implements the Gaussian mechanism of differential privacy,
for privatizing numeric vector releases.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: automatically prints the object.
}}

\section{Slots}{

\describe{
\item{\code{sensitivity}}{non-negative scalar numeric L2 target sensitivity.
Defaults to \code{Inf} for use with \code{sensitivitySampler()}.}

\item{\code{target}}{the target non-private function to be privatized, takes lists.
Defaults to a constant function. Gaussian mechanism assumes functions that
release numeric vectors of fixed dimension \code{dims}.}

\item{\code{gammaSensitivity}}{\code{NA_real_} if inactive, or scalar in [0,1)
indicating that responses must be RDP with specific confidence.}

\item{\code{dims}}{positive scalar numeric dimension of responses. Defaults to
\code{NA_integer_} for use with \code{sensitivitySampler()} which can
probe \code{target} to determine dimension.}
}}

\references{
Cynthia Dwork and Aaron Roth. "Algorithmic Foundations of
Differential Privacy" Foundations and Trends in Theoretical Computer
Science. Now Publishers, 2014.
}
