% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stick_breaking.R
\name{StickBreaking}
\alias{StickBreaking}
\alias{piDirichlet}
\title{The Stick Breaking representation of the Dirichlet process.}
\usage{
StickBreaking(alpha, N)

piDirichlet(betas)
}
\arguments{
\item{alpha}{Concentration parameter of the Dirichlet Process.}

\item{N}{Truncation value.}

\item{betas}{Draws from the Beta distribution.}
}
\value{
Vector of stick breaking probabilities.
}
\description{
A Dirichlet process can be represented using a stick breaking construction
\deqn{G = \sum _{i=1} ^n pi _i \delta _{\theta _i}},
where \eqn{\pi _k = \beta _k  \prod _{k=1} ^{n-1} (1- \beta _k )} are the stick breaking weights.
The atoms \eqn{\delta _{\theta _i}} are drawn from \eqn{G_0} the base measure of the Dirichlet Process.
The \eqn{\beta _k \sim \mathrm{Beta} (1, \alpha)}. In theory \eqn{n} should be infinite, but we chose some value of \eqn{N} to truncate
the series. For more details see reference.
}
\section{Functions}{
\itemize{
\item \code{piDirichlet()}: Function for calculating stick lengths.

}}
\references{
Ishwaran, H., & James, L. F. (2001). Gibbs sampling methods for stick-breaking priors. Journal of the American Statistical Association, 96(453), 161-173.
}
