% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEvaluationCR.R
\name{cIndexCompRisks}
\alias{cIndexCompRisks}
\title{Discrete concordance index for competing risks}
\usage{
cIndexCompRisks(markers, testTime, testEvents, trainTime, trainEvents)
}
\arguments{
\item{markers}{Predictions on the test data with model fitted on training data ("numeric matrix").
Predictions are stored in the rows and the number of columns equal to the number of events.}

\item{testTime}{New time intervals in the test data ("integer vector").}

\item{testEvents}{New event indicators (0 or 1) in the test data ("binary matrix"). Number of columns are
equal to the number of events.}

\item{trainTime}{Time intervals in the training data ("integer vector").}

\item{trainEvents}{Event indicators (0 or 1) in the training data ("binary matrix"). Number of columns are
equal to the number of events.}
}
\value{
Value of discrete concordance index between zero and one ("numeric vector").
}
\description{
Estimates the discrete concordance index in the case of competing risks.
}
\note{
It is assumed that all time points up to the last observed interval
[a_{q-1}, a_q) are available.
}
\examples{

##################################################
# Example with unemployment data and prior fitting

library(Ecdat)
data(UnempDur)
summary(UnempDur$spell)
# Extract subset of data
set.seed(635)
IDsample <- sample(1:dim(UnempDur)[1], 100)
UnempDurSubset <- UnempDur [IDsample, ]
set.seed(-570)
TrainingSample <- sample(1:100, 75)
UnempDurSubsetTrain <- UnempDurSubset [TrainingSample, ]
UnempDurSubsetTest <- UnempDurSubset [-TrainingSample, ]

# Convert to long format
UnempDurSubsetTrainLong <- dataLongCompRisks(dataShort = UnempDurSubsetTrain, timeColumn = "spell", 
eventColumns = c("censor1", "censor4"), timeAsFactor = TRUE)

# Estimate continuation ratio model with logit link
vglmFit <- VGAM::vglm(formula = cbind(e0, e1, e2) ~ timeInt + age + logwage, 
data = UnempDurSubsetTrainLong, family=VGAM::multinomial(refLevel = "e0"))

gamFitPreds <- VGAM::predictvglm(vglmFit , newdata = cbind(UnempDurSubsetTest, 
timeInt = as.factor(UnempDurSubsetTest$spell)))

# Evaluate C-Index based on short data format
cIndexCompRisks(markers = gamFitPreds, 
testTime = UnempDurSubsetTest$spell, 
testEvents = UnempDurSubsetTest[, c("censor1", "censor4")], 
trainTime = UnempDurSubsetTrain$spell, 
trainEvents = UnempDurSubsetTrain[, c("censor1", "censor4")])

}
\references{
\insertRef{heyardValCompRisks}{discSurv}
}
\seealso{
\code{\link{cIndex}}
}
\author{
Moritz Berger \email{moritz.berger@imbie.uni-bonn.de} \cr \url{https://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
\keyword{competing_risks}
\keyword{discrete_survival}
\keyword{discrimination}
