% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIFI.R
\name{getIFI}
\alias{getIFI}
\title{Inter-Flood Interval (IFI)}
\usage{
getIFI(resid, years, lowflow.start, lowflow.end, unique.years,
  for.year = NULL)
}
\arguments{
\item{resid}{A vector of residual values generated with respect to the baseline signal}

\item{years}{A vector of years corrosponding to the residual values}

\item{lowflow.start}{A vector giving start index of low-flow window in each year}

\item{lowflow.end}{A vector giving end index of low-flow window in each year}

\item{unique.years}{A vector or year values corresponding to the \code{highflow.start} 
and \code{highflow.end} values.}

\item{for.year}{(optional) Calculate IFI values only for the given year in this argument.
If argument is omitted, IFI values for all years are calculated.}
}
\value{
Data frame containing two columns:
\tabular{ll}{
\code{year} \tab First column, represents year \cr
\code{IFI} \tab Second column, represents IFI values
}
}
\description{
Compute Inter-Flood Interval (IFI) from the given residual values.
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# prepare baseline signal 
x.bl = prepareBaseline(x.streamflow)

# signal parts
x.sp = getSignalParts(x.bl$pred2, candmin = c(40:125), candmax = c(190:330),
                      years = x.streamflow$data$year, 
                      months = x.streamflow$data$month,
                      jdays = x.streamflow$data$jday)

# IFI
ifi = getIFI(x.bl$resid.sig, x.streamflow$data$year, x.sp$LF.window.start, 
             x.sp$LF.window.end, x.sp$year)

}
