% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{duplicated_tol}
\alias{duplicated_tol}
\title{Identify duplicated values in a sorted numeric vector, where comparison is
up to a specified numeric tolerance. If there is a run of values where each
consecutive pair is closer together than the tolerance, all are labeled as
duplicates even if not all values in the run are within the tolerance.}
\usage{
duplicated_tol(x, tol = 1e-06, incl_first = FALSE)
}
\arguments{
\item{x}{a numeric vector in which to identify duplicates}

\item{tol}{numeric tolerance for identifying duplicates}

\item{incl_first}{boolean indicator of whether or not the first entry in a
run of duplicates should be indicated as a duplicate. \code{FALSE} mirrors the
behavior of the base R function \code{duplicated}.}
}
\value{
a boolean vector of the same length as \code{x}
}
\description{
Identify duplicated values in a sorted numeric vector, where comparison is
up to a specified numeric tolerance. If there is a run of values where each
consecutive pair is closer together than the tolerance, all are labeled as
duplicates even if not all values in the run are within the tolerance.
}
