% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disto_methods.R
\name{dapply}
\alias{dapply}
\title{Matrix like apply function for disto object}
\usage{
dapply(x, margin = 1, fun, subset, nproc = 1)
}
\arguments{
\item{x}{disto object}

\item{margin}{(one among 1 or 2) dimension to apply function along}

\item{fun}{Function to apply over the margin}

\item{subset}{(integer vector) Row/Column numbers along the margin}

\item{nproc}{Number of parallel processes (unix only)}
}
\value{
Simplified output of 'sapply' like function
temp <- dist(iris[,1:4])
dio  <- disto(objectname = "temp")

# function to pick indexes of 5 nearest neighbors
# an efficient alternative with Rcpp is required
udf <- function(x){
  dim(x) <- NULL
  order(x)[1:6]
  }
hi <- dapply(dio, 1, udf)[-1, ]
dim(hi)
}
\description{
Apply function for data underlying disto object
}
