% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechet.R
\name{frechet}
\alias{frechet}
\alias{dfrechet}
\alias{pfrechet}
\alias{qfrechet}
\alias{mfrechet}
\alias{rfrechet}
\title{The Fréchet distribution}
\usage{
dfrechet(x, shape = 1.5, scale = 0.5, log = FALSE)

pfrechet(q, shape = 1.5, scale = 0.5, log.p = FALSE, lower.tail = TRUE)

qfrechet(p, shape = 1.5, scale = 0.5, log.p = FALSE, lower.tail = TRUE)

mfrechet(r = 0, truncation = 0, shape = 1.5, scale = 0.5, lower.tail = TRUE)

rfrechet(n, shape = 1.5, scale = 0.5)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{shape, scale}{Shape and scale of the Fréchet distribution, defaults to 1.5 and 0.5 respectively.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities (moments) are \eqn{P[X \le x]} \eqn{\left(E[x^r|X \le y]\right)}, otherwise, \eqn{P[X > x]} \eqn{\left(E[x^r|X > y]\right)}}

\item{p}{vector of probabilities}

\item{r}{rth raw moment of the distribution}

\item{truncation}{lower truncation parameter}

\item{n}{number of observations}
}
\value{
dfrechet returns the density, pfrechet the distribution function, qfrechet the quantile function, mfrechet the rth moment of the distribution and rfrechet generates random deviates.

 The length of the result is determined by n for rfrechet, and is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function, raw moments and random generation for the Fréchet distribution.
}
\details{
Probability and Cumulative Distribution Function:

 \deqn{f(x) =\frac{shape}{scale}\left(\frac{\omega}{scale}\right)^{-1-shape} e^{-\left(\frac{\omega}{scale}\right)^{-shape}}, \qquad F_X(x) = e^{-\left(\frac{\omega}{scale}\right)^{-shape}}}

 The y-bounded r-th raw moment of the Fréchet distribution equals:

 \deqn{ \mu^{r}_{y} = scale^{\sigma_s - 1} \left[1-\Gamma\left(1-\frac{\sigma_s - 1}{shape}, \left(\frac{y}{scale}\right)^{-shape} \right)\right],  \qquad shape>r}
}
\examples{

## Frechet density
plot(x = seq(0, 5, length.out = 100), y = dfrechet(x = seq(0, 5, length.out = 100),
shape = 1, scale = 1))
plot(x = seq(0, 5, length.out = 100), y = dfrechet(x = seq(0, 5, length.out = 100),
shape = 2, scale = 1))
plot(x = seq(0, 5, length.out = 100), y = dfrechet(x = seq(0, 5, length.out = 100),
shape = 3, scale = 1))
plot(x = seq(0, 5, length.out = 100), y = dfrechet(x = seq(0, 5, length.out = 100),
shape = 3, scale = 2))

## frechet is also called the inverse weibull distribution, which is available in the stats package
pfrechet(q = 5, shape = 2, scale = 1.5)
1 - pweibull(q = 1 / 5, shape = 2, scale = 1 / 1.5)

## Demonstration of log functionality for probability and quantile function
qfrechet(pfrechet(2, log.p = TRUE), log.p = TRUE)

## The zeroth truncated moment is equivalent to the probability function
pfrechet(2)
mfrechet(truncation = 2)

## The (truncated) first moment is equivalent to the mean of a (truncated) random sample,
#for large enough samples.
x <- rfrechet(1e5, scale = 1)

mean(x)
mfrechet(r = 1, lower.tail = FALSE, scale = 1)

sum(x[x > quantile(x, 0.1)]) / length(x)
mfrechet(r = 1, truncation = quantile(x, 0.1), lower.tail = FALSE, scale = 1)
}
