% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnorm.R
\name{lnorm_plt}
\alias{lnorm_plt}
\title{Log Normal coefficients of power-law transformed log normal}
\usage{
lnorm_plt(meanlog = 0, sdlog = 1, a = 1, b = 1, inv = FALSE)
}
\arguments{
\item{meanlog, sdlog}{mean and standard deviation of the log normal distributed variable, defaults to 0 and 1 respectively.}

\item{a, b}{constant and power of power-law transformation, defaults to 1 and 1 respectively.}

\item{inv}{logical indicating whether coefficients of the outcome variable of the power-law transformation should be returned (FALSE) or whether coefficients of the input variable being power-law transformed should be returned (TRUE). Defaults to FALSE.}
}
\value{
Returns a named list containing
\describe{
\item{coefficients}{Named vector of coefficients}
}

 ## Comparing probabilites of power-law transformed transformed variables
 plnorm(3,meanlog=-0.5,sdlog=0.5)
 coeff = lnorm_plt(meanlog=-0.5,sdlog=0.5,a=5,b=7)$coefficients
 plnorm(5*3^7,meanlog=coeff[["meanlog"]],sdlog=coeff[["sdlog"]])

 plnorm(5*0.8^7,meanlog=-0.5,sdlog=0.5)
 coeff = lnorm_plt(meanlog=-0.5,sdlog=0.5,a=5,b=7,inv=TRUE)$coefficients
 plnorm(0.8,meanlog=coeff[["meanlog"]],sdlog=coeff[["sdlog"]])

 ## Comparing the first moments and sample means of power-law transformed variables for large enough samples
 x = rlnorm(1e5,meanlog=-0.5,sdlog=0.5)
 coeff = lnorm_plt(meanlog=-0.5,sdlog=0.5,a=2,b=0.5)$coefficients
 y = rlnorm(1e5,meanlog=coeff[["meanlog"]],sdlog=coeff[["sdlog"]])
 mean(2*x^0.5)
 mean(y)
 mlnorm(r=1,meanlog=coeff[["meanlog"]],sdlog=coeff[["sdlog"]],lower.tail=FALSE)
}
\description{
Coefficients of a power-law transformed log normal distribution
}
\details{
If the random variable y is log normally distributed with mean meanlog and standard deviation sdlog, then the power-law transformed variable

 \deqn{ y = ax^b }

 is log normally distributed with mean \eqn{ \frac{meanlog - ln(a)}{b} } and standard deviation \eqn{\frac{sdlog}{b}}.
}
