% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{dlmtree.control.diagnose}
\alias{dlmtree.control.diagnose}
\title{Diagnostic control settings for dlmtree model fitting}
\usage{
dlmtree.control.diagnose(
  subset = NULL,
  lowmem = FALSE,
  verbose = TRUE,
  save.data = TRUE,
  diagnostics = FALSE,
  initial.params = NULL
)
}
\arguments{
\item{subset}{integer vector to analyze only a subset of data and exposures.}

\item{lowmem}{TRUE or FALSE (default): turn on memory saver for DLNM, slower computation time.}

\item{verbose}{TRUE (default) or FALSE: print output}

\item{save.data}{TRUE (default) or FALSE: save data used for model fitting. This must be set to TRUE to use shiny() function on hdlm or hdlmm}

\item{diagnostics}{TRUE or FALSE (default) keep model diagnostic such as the number of
terminal nodes and acceptance ratio.}

\item{initial.params}{initial parameters for fixed effects model, FALSE = none (default), 
"glm" = generate using GLM, or user defined, length must equal number of parameters in fixed effects model.}
}
\value{
list of control parameters for diagnostics.
}
\description{
Diagnostic control settings for dlmtree model fitting
}
